/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Vector;
import oracle.ldap.util.Base64;
import oracle.ldap.util.InvalidLDIFRecordException;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;

public class LDIFReader {
    private static final char COMMENT = '#';
    private static String DEFAULT_ENCODING = null;
    private String m_encoding = null;
    private String lookAheadBuf = null;
    private BufferedReader inBuf = null;
    private boolean isEndOfEntry = false;
    private int currLineNo = -1;
    private boolean previousValue = false;
    private boolean attrValAsFileContent = false;
    private String[] binaryAttributes = null;
    private String version = null;
    private boolean firstRecord = true;

    public LDIFReader() throws IOException {
        this.inBuf = new BufferedReader(new InputStreamReader(System.in, DEFAULT_ENCODING));
        this.m_encoding = DEFAULT_ENCODING;
    }

    public LDIFReader(String string) throws IOException {
        this(string, DEFAULT_ENCODING);
    }

    public LDIFReader(String string, String string2) throws IOException {
        this.inBuf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
        this.m_encoding = string2;
    }

    public LDIFReader(File file) throws IOException {
        this(file, DEFAULT_ENCODING);
    }

    public LDIFReader(File file, String string) throws IOException {
        this.inBuf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        this.m_encoding = string;
    }

    public LDIFReader(InputStream inputStream) throws IOException {
        this(inputStream, DEFAULT_ENCODING);
    }

    public LDIFReader(InputStream inputStream, String string) throws IOException {
        this.inBuf = new BufferedReader(new InputStreamReader(inputStream, string));
        this.m_encoding = string;
    }

    private void ensureOpen() throws IOException {
        if (this.inBuf == null) {
            throw new IOException("Stream closed");
        }
    }

    private synchronized String readAttributeLine() throws IOException {
        Object[] objectArray;
        block11: {
            block12: {
                Object[] objectArray2;
                Object[] objectArray3;
                block10: {
                    objectArray = null;
                    this.ensureOpen();
                    if (this.isEndOfEntry) break block12;
                    while (true) {
                        String string;
                        objectArray = this.inBuf.readLine();
                        ++this.currLineNo;
                        if (objectArray == null) break block10;
                        if (objectArray.length() < 1) {
                            if (this.lookAheadBuf == null) continue;
                            if (this.lookAheadBuf.charAt(0) == '#') {
                                objectArray = null;
                                this.lookAheadBuf = null;
                                if (!this.previousValue) continue;
                                this.previousValue = false;
                            } else {
                                if (this.firstRecord && (objectArray3 = (String)(objectArray2 = this.getAttrNV(this.lookAheadBuf))[0]).equalsIgnoreCase("version")) {
                                    this.version = (String)objectArray2[1];
                                    this.firstRecord = false;
                                    this.lookAheadBuf = null;
                                    continue;
                                }
                                objectArray = this.lookAheadBuf;
                                this.lookAheadBuf = null;
                                this.isEndOfEntry = true;
                                this.firstRecord = false;
                            }
                            break block11;
                        }
                        if (this.lookAheadBuf == null) {
                            this.lookAheadBuf = objectArray;
                            continue;
                        }
                        if (objectArray.charAt(0) == ' ' || objectArray.charAt(0) == '\t') {
                            this.lookAheadBuf = this.lookAheadBuf + objectArray.substring(1);
                            continue;
                        }
                        objectArray2 = this.lookAheadBuf;
                        this.lookAheadBuf = objectArray;
                        objectArray = objectArray2;
                        if (objectArray.charAt(0) == '#') continue;
                        if (!this.firstRecord || !(string = (String)(objectArray3 = this.getAttrNV((String)objectArray))[0]).equalsIgnoreCase("version")) break;
                        this.version = (String)objectArray3[1];
                        this.firstRecord = false;
                    }
                    this.firstRecord = false;
                    this.previousValue = true;
                    break block11;
                }
                this.isEndOfEntry = true;
                objectArray = this.lookAheadBuf;
                this.lookAheadBuf = null;
                if (objectArray != null && objectArray.charAt(0) == '#') {
                    objectArray = null;
                } else if (this.firstRecord && objectArray != null && (objectArray3 = (Object[])(objectArray2 = this.getAttrNV((String)objectArray))[0]).equalsIgnoreCase("version")) {
                    this.version = (String)objectArray2[1];
                    this.firstRecord = false;
                }
                break block11;
            }
            this.isEndOfEntry = false;
            this.previousValue = false;
        }
        return objectArray;
    }

    public void setBinaryAttributes(String[] stringArray) {
        this.binaryAttributes = stringArray;
    }

    private boolean isBinaryAttribute(String string) {
        if (null != string && null != this.binaryAttributes && 0 != this.binaryAttributes.length) {
            int n = 0;
            while (n < this.binaryAttributes.length) {
                if (string.equalsIgnoreCase(this.binaryAttributes[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public Vector nextEntry() throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = null;
        while ((string = this.readAttributeLine()) != null) {
            vector.addElement(string);
        }
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    private byte[] string2bytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.m_encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    private String bytes2string(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, this.m_encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getMessage());
        }
        return string;
    }

    private Object[] getAttrNV(String string) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = new Object[3];
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = "";
        byte[] byArray = null;
        objectArray[2] = "0";
        n = string.indexOf(":");
        if (n == -1) {
            throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_ATTRIBUTE");
        }
        string2 = string.substring(n2, n).trim();
        if (string2.equals("")) {
            throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_ATTRIBUTE");
        }
        if (n + 1 < n3) {
            if (string.charAt(n + 1) == ':') {
                ++n;
                bl = true;
            } else if (string.charAt(n + 1) == '<') {
                ++n;
                bl2 = true;
            }
        }
        n2 = n + 1;
        n = n3;
        string3 = string.substring(n2, n).trim();
        if (bl2) {
            byArray = this.readFile(string3);
            if (this.isBinaryAttribute(string2)) {
                objectArray[2] = "1";
            } else {
                string3 = this.bytes2string(byArray);
            }
        } else if (bl) {
            if (this.isBinaryAttribute(string2)) {
                byArray = Base64.decode(this.string2bytes(string3));
                objectArray[2] = "1";
            } else {
                string3 = this.bytes2string(Base64.decode(this.string2bytes(string3)));
            }
        } else if (this.attrValAsFileContent && !string3.equals("") && (string3.startsWith("/") || string3.indexOf(":") == 1)) {
            byArray = this.readFile(string3);
            if (this.isBinaryAttribute(string2)) {
                objectArray[2] = "1";
            } else {
                string3 = this.bytes2string(byArray);
            }
        }
        objectArray[0] = string2;
        objectArray[1] = objectArray[2].equals("1") ? byArray : (byte[])string3;
        return objectArray;
    }

    private byte[] readFile(String string) {
        byte[] byArray = null;
        try {
            BufferedInputStream bufferedInputStream = null;
            if (string.startsWith("/") || string.indexOf(":") == 1) {
                File file = new File(string);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)), 4096);
            } else {
                bufferedInputStream = new BufferedInputStream(new URL(string).openStream(), 4096);
            }
            byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray, 0, byArray.length);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidLDIFRecordException(this.currLineNo, iOException.getMessage());
        }
        return byArray;
    }

    private void handleRecChangeTypeModDn(LDIFRecord lDIFRecord) throws IOException {
        lDIFRecord.setChangeType(4);
        String string = this.readAttributeLine();
        if (string == null) {
            throw new InvalidLDIFRecordException(this.currLineNo, "NEWRDN_EXPECTED");
        }
        Object[] objectArray = this.getAttrNV(string);
        String string2 = (String)objectArray[0];
        String string3 = (String)objectArray[1];
        if (!string2.equalsIgnoreCase("newrdn") || string3 == null || string3.equals("")) {
            throw new InvalidLDIFRecordException(this.currLineNo, "NEWRDN_EXPECTED");
        }
        boolean bl = false;
        String string4 = null;
        String string5 = this.readAttributeLine();
        while (null != string5) {
            Object[] objectArray2 = this.getAttrNV(string5);
            String string6 = (String)objectArray2[0];
            String string7 = (String)objectArray2[1];
            if (string6.equalsIgnoreCase("deleteoldrdn")) {
                if (string7 == null || !string7.equals("1") && !string7.equals("0")) {
                    throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_DELETEOLDRDN_0/1_EXPECTED");
                }
                bl = string7.equals("1");
                string5 = this.readAttributeLine();
                continue;
            }
            if (string6.equalsIgnoreCase("newsuperior")) {
                if (string7 == null || string7.equals("")) {
                    throw new InvalidLDIFRecordException(this.currLineNo, "NEWSUPERIOR_VALUE_EXPECTED");
                }
                string4 = string7;
                string5 = this.readAttributeLine();
                continue;
            }
            throw new InvalidLDIFRecordException(this.currLineNo, "UNKNOWN_ATTRIBUTE");
        }
        lDIFRecord.setNewRdn(string3, bl, string4);
    }

    private void handleRecChangeTypeDelete(LDIFRecord lDIFRecord) throws IOException {
        lDIFRecord.setChangeType(2);
        String string = this.readAttributeLine();
        if (string != null) {
            throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_NOT_EXPECTED");
        }
    }

    private void handleRecChangeTypeModify(LDIFRecord lDIFRecord) throws IOException {
        lDIFRecord.setChangeType(3);
        String string = null;
        boolean bl = false;
        while ((string = this.readAttributeLine()) != null) {
            Object[] objectArray = this.getAttrNV(string);
            String string2 = (String)objectArray[0];
            String string3 = (String)objectArray[1];
            int n = 5;
            boolean bl2 = false;
            if (string2.equalsIgnoreCase("changetype")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "REC_CHANGE_ALREADY_DEFINED");
            }
            if (string2.equalsIgnoreCase("delete")) {
                n = 6;
            } else if (string2.equalsIgnoreCase("replace")) {
                n = 7;
            } else if (!string2.equalsIgnoreCase("add")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_ATTRIBUTE_CHANGE_TYPE");
            }
            if (string3 == null || string3.equals("")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_VALUE_MANDATORY");
            }
            string2 = string3;
            bl2 = this.isBinaryAttribute(string2);
            LDIFAttribute lDIFAttribute = new LDIFAttribute(string2, bl2);
            lDIFAttribute.setChangeType(n);
            String string4 = null;
            while ((string4 = this.readAttributeLine()) != null && !string4.trim().equals("-")) {
                Object[] objectArray2 = this.getAttrNV(string4);
                String string5 = (String)objectArray2[0];
                String string6 = null;
                byte[] byArray = null;
                if (bl2) {
                    byArray = (byte[])objectArray2[1];
                } else {
                    string6 = (String)objectArray2[1];
                }
                if (!string5.equalsIgnoreCase(string2)) {
                    throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_TYPE_NAME_MISMATCH");
                }
                if (bl2) {
                    lDIFAttribute.addValue(byArray);
                } else {
                    lDIFAttribute.addValue(string6);
                }
                bl = true;
            }
            if (!bl && n == 5) {
                throw new InvalidLDIFRecordException(this.currLineNo, "NO_ATTRIBUTE_ADD_CHANGE_VALUE");
            }
            lDIFRecord.addAttribute(lDIFAttribute);
            if (string4 != null) continue;
            return;
        }
    }

    private void handleChangeRecord(LDIFRecord lDIFRecord, String string) throws IOException {
        Object var3_3 = null;
        if (string == null || string.equals("")) {
            throw new InvalidLDIFRecordException(this.currLineNo, "REC_CHANGE_NOT_DEFINED");
        }
        if (string.equalsIgnoreCase("delete")) {
            this.handleRecChangeTypeDelete(lDIFRecord);
        } else if (string.equalsIgnoreCase("modify")) {
            this.handleRecChangeTypeModify(lDIFRecord);
        } else if (string.equalsIgnoreCase("modrdn") || string.equalsIgnoreCase("moddn")) {
            this.handleRecChangeTypeModDn(lDIFRecord);
        } else if (string.equalsIgnoreCase("add")) {
            this.handleAttrValueRecord(lDIFRecord);
        } else {
            throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_RECORD_CHANGE_TYPE");
        }
        lDIFRecord.setExpChgType(true);
    }

    private void handleAttrValueRecord(LDIFRecord lDIFRecord) throws IOException {
        lDIFRecord.setChangeType(1);
        String string = null;
        while ((string = this.readAttributeLine()) != null) {
            Object[] objectArray = this.getAttrNV(string);
            String string2 = (String)objectArray[0];
            String string3 = null;
            byte[] byArray = null;
            LDIFAttribute lDIFAttribute = lDIFRecord.getAttribute(string2);
            if (objectArray[2].equals("1")) {
                byArray = (byte[])objectArray[1];
            } else {
                string3 = (String)objectArray[1];
            }
            if (lDIFAttribute == null) {
                lDIFAttribute = objectArray[2].equals("1") ? new LDIFAttribute(string2, byArray, true) : new LDIFAttribute(string2, string3);
                lDIFRecord.addAttribute(lDIFAttribute);
                continue;
            }
            if (objectArray[2].equals("1")) {
                lDIFAttribute.addValue(byArray);
                continue;
            }
            lDIFAttribute.addValue(string3);
        }
    }

    public synchronized LDIFRecord nextRecord() throws IOException {
        LDIFRecord lDIFRecord = null;
        String string = null;
        string = this.readAttributeLine();
        if (string != null) {
            Object[] objectArray = this.getAttrNV(string);
            String string2 = (String)objectArray[0];
            String string3 = (String)objectArray[1];
            Object var6_6 = null;
            if (!string2.equalsIgnoreCase("dn")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "DN_NOT_FIRST");
            }
            lDIFRecord = new LDIFRecord(string3);
            string = this.readAttributeLine();
            if (string != null) {
                objectArray = this.getAttrNV(string);
                string2 = (String)objectArray[0];
                if (string2.equalsIgnoreCase("changetype")) {
                    this.handleChangeRecord(lDIFRecord, (String)objectArray[1]);
                } else {
                    LDIFAttribute lDIFAttribute = objectArray[2].equals("1") ? new LDIFAttribute(string2, (byte[])objectArray[1], true) : new LDIFAttribute(string2, (String)objectArray[1]);
                    lDIFRecord.addAttribute(lDIFAttribute);
                    this.handleAttrValueRecord(lDIFRecord);
                }
            }
        }
        return lDIFRecord;
    }

    public void close() throws IOException {
        if (this.inBuf != null) {
            this.inBuf.close();
            this.inBuf = null;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setReadFileContentForAttrib(boolean bl) {
        this.attrValAsFileContent = bl;
    }

    private static void test1(String string) {
        LDIFReader lDIFReader = null;
        String[] stringArray = new String[]{"jpegphoto"};
        try {
            lDIFReader = new LDIFReader(string);
            lDIFReader.setBinaryAttributes(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Error while reading LDIF file " + string);
            System.err.println(exception.toString());
            System.exit(1);
        }
        try {
            LDIFRecord lDIFRecord = null;
            while ((lDIFRecord = lDIFReader.nextRecord()) != null) {
                System.out.println(lDIFRecord);
            }
            lDIFReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while reading the LDIF File " + string);
            System.exit(1);
        }
    }

    private static void test2(String string) {
        LDIFReader lDIFReader = null;
        try {
            lDIFReader = new LDIFReader(string);
        }
        catch (Exception exception) {
            System.err.println("Error while reading LDIF file " + string);
            System.err.println(exception.toString());
            System.exit(1);
        }
        try {
            Object var2_3 = null;
            Vector vector = null;
            boolean bl = false;
            while ((vector = lDIFReader.nextEntry()) != null) {
                int n = 0;
                while (n < vector.size()) {
                    System.out.println(vector.elementAt(n));
                    ++n;
                }
                System.out.println();
            }
            lDIFReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while reading the LDIF File " + string);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: java LDIFReader <FILE1>");
            System.exit(1);
        }
        LDIFReader.test1(stringArray[0]);
        LDIFReader.test2(stringArray[0]);
    }

    static {
        DEFAULT_ENCODING = System.getProperty("file.encoding");
    }
}

